/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzacraft.client;

import com.google.common.collect.ImmutableList;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import com.tiviacz.pizzacraft.init.PizzaLayers;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.items.IItemHandler;

public class PizzaBakedModel
implements BakedModel {
    private final BakedModel baseModel;
    private final FaceBakery faceBakery = new FaceBakery();
    public static ModelProperty<Optional<IItemHandler>> LAYER_PROVIDERS = new ModelProperty();
    public static ModelProperty<Optional<Integer>> INTEGER_PROPERTY = new ModelProperty();
    public static ModelProperty<Optional<Boolean>> IS_RAW = new ModelProperty();
    protected static final float[][] VECTORS = new float[][]{{1.0f, 1.0f, 1.0f}, {3.0f, 1.0f, 1.0f}, {5.0f, 1.0f, 1.0f}, {7.0f, 1.0f, 1.0f}, {9.0f, 1.0f, 1.0f}, {11.0f, 1.0f, 1.0f}, {13.0f, 1.0f, 1.0f}, {15.0f, 1.0f, 15.0f}};
    protected static final float[][][] UV = new float[][][]{new float[][]{{1.0f, 1.0f, 15.0f, 15.0f}, {3.0f, 1.0f, 15.0f, 15.0f}, {5.0f, 1.0f, 15.0f, 15.0f}, {7.0f, 1.0f, 15.0f, 15.0f}, {9.0f, 1.0f, 15.0f, 15.0f}, {11.0f, 1.0f, 15.0f, 15.0f}, {13.0f, 1.0f, 15.0f, 15.0f}}, new float[][]{{1.0f, 1.0f, 15.0f, 15.0f}, {1.0f, 1.0f, 15.0f, 13.0f}, {1.0f, 1.0f, 15.0f, 11.0f}, {1.0f, 1.0f, 15.0f, 9.0f}, {1.0f, 1.0f, 15.0f, 7.0f}, {1.0f, 1.0f, 15.0f, 5.0f}, {1.0f, 1.0f, 15.0f, 3.0f}}, new float[][]{{1.0f, 1.0f, 15.0f, 15.0f}, {1.0f, 1.0f, 13.0f, 15.0f}, {1.0f, 1.0f, 11.0f, 15.0f}, {1.0f, 1.0f, 9.0f, 15.0f}, {1.0f, 1.0f, 7.0f, 15.0f}, {1.0f, 1.0f, 5.0f, 15.0f}, {1.0f, 1.0f, 3.0f, 15.0f}}, new float[][]{{1.0f, 1.0f, 15.0f, 15.0f}, {1.0f, 3.0f, 15.0f, 15.0f}, {1.0f, 5.0f, 15.0f, 15.0f}, {1.0f, 7.0f, 15.0f, 15.0f}, {1.0f, 9.0f, 15.0f, 15.0f}, {1.0f, 11.0f, 15.0f, 15.0f}, {1.0f, 13.0f, 15.0f, 15.0f}}};

    public PizzaBakedModel(BakedModel baseModel) {
        this.baseModel = baseModel;
    }

    public static ModelData getEmptyModelData() {
        ModelData.Builder builder = ModelData.builder();
        builder.with(LAYER_PROVIDERS, Optional.empty());
        builder.with(INTEGER_PROPERTY, Optional.empty());
        builder.with(IS_RAW, Optional.empty());
        ModelData modelData = builder.build();
        return modelData;
    }

    @Nonnull
    public ModelData getModelData(@Nonnull BlockAndTintGetter level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull ModelData blockEntityData) {
        return blockEntityData;
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, @Nullable RenderType renderType) {
        if (side != null) {
            return this.baseModel.m_213637_(state, side, rand);
        }
        return this.getBakedQuadsFromIModelData(state, side, rand, extraData, renderType);
    }

    private List<BakedQuad> getBakedQuadsFromIModelData(@Nullable BlockState state, Direction side, @Nonnull RandomSource rand, @Nonnull ModelData data, @Nullable RenderType renderType) {
        if (!(data.has(LAYER_PROVIDERS) && data.has(INTEGER_PROPERTY) && data.has(IS_RAW))) {
            return this.baseModel.m_213637_(state, side, rand);
        }
        Optional layerProviders = (Optional)data.get(LAYER_PROVIDERS);
        Optional integerProperty = (Optional)data.get(INTEGER_PROPERTY);
        Optional isRaw = (Optional)data.get(IS_RAW);
        if (!(layerProviders.isPresent() && integerProperty.isPresent() && isRaw.isPresent())) {
            return this.baseModel.m_213637_(state, side, rand);
        }
        List<BakedQuad> layerQuads = this.getLayerQuads((IItemHandler)layerProviders.get(), (Integer)integerProperty.get(), (Boolean)isRaw.get());
        LinkedList<BakedQuad> allQuads = new LinkedList<BakedQuad>();
        allQuads.addAll(this.baseModel.getQuads(state, side, rand, data, renderType));
        allQuads.addAll(layerQuads);
        return allQuads;
    }

    public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
        throw new AssertionError((Object)"IBakedModel::getQuads should never be called, only IForgeBakedModel::getQuads");
    }

    private List<BakedQuad> getLayerQuads(IItemHandler inventory, int integerProperty, boolean isRaw) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        int rotation = 0;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            if (inventory.getStackInSlot(i).m_41619_()) continue;
            for (int j = 0; j < i; ++j) {
                if (inventory.getStackInSlot(j).m_41720_() != inventory.getStackInSlot(i).m_41720_()) continue;
                rotation += 90;
            }
            for (Direction dir : Direction.values()) {
                ResourceLocation layerLocation = null;
                List tags = inventory.getStackInSlot(i).m_204131_().toList();
                for (TagKey tag : tags) {
                    if (!PizzaLayers.VALID_TAGS.contains(tag)) continue;
                    layerLocation = isRaw ? PizzaLayers.getTagToRawLayer().get(tag) : PizzaLayers.getTagToLayer().get(tag);
                }
                if (layerLocation == null) {
                    layerLocation = MissingTextureAtlasSprite.m_118071_();
                }
                builder.add((Object)this.getQuadForLayer(layerLocation, dir, rotation, UV[rotation / 90 % 4][integerProperty], VECTORS[integerProperty][0], VECTORS[integerProperty][1], VECTORS[integerProperty][2], VECTORS[7][0], VECTORS[7][1], VECTORS[7][2]));
            }
        }
        return builder.build();
    }

    private BakedQuad getQuadForLayer(ResourceLocation layerLocation, Direction face, int rotation, float[] uvArray, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        Vector3f from = new Vector3f((float)minX, (float)minY, (float)minZ);
        Vector3f to = new Vector3f((float)maxX, (float)maxY, (float)maxZ);
        BlockFaceUV blockFaceUV = new BlockFaceUV(uvArray, rotation);
        BlockElementFace blockElementFace = new BlockElementFace(face, -1, "", blockFaceUV);
        TextureAtlasSprite layersTextures = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(layerLocation);
        ResourceLocation DUMMY_RL = new ResourceLocation("dummy_name");
        BakedQuad bakedQuad = this.faceBakery.m_111600_(from, to, blockElementFace, layersTextures, face, (ModelState)new SimpleModelState(Transformation.m_121093_()), null, true, DUMMY_RL);
        return bakedQuad;
    }

    public boolean m_7541_() {
        return this.baseModel.m_7541_();
    }

    public boolean m_7539_() {
        return this.baseModel.m_7539_();
    }

    public boolean m_7547_() {
        return this.baseModel.m_7547_();
    }

    public boolean m_7521_() {
        return this.baseModel.m_7521_();
    }

    public TextureAtlasSprite m_6160_() {
        return this.baseModel.m_6160_();
    }

    public ItemOverrides m_7343_() {
        return this.baseModel.m_7343_();
    }
}

